/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.particle;

import com.dfdyz.epicacg.client.render.EpicACGRenderType;
import com.dfdyz.epicacg.client.render.pipeline.PostEffectPipelines;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.client.model.ItemSkin;
import yesman.epicfight.api.client.model.ItemSkins;
import yesman.epicfight.api.utils.math.CubicBezierCurve;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class BloomTrailParticle
extends TextureSheetParticle {
    private final Joint joint;
    private final TrailInfo trailInfo;
    private final StaticAnimation animation;
    private final LivingEntityPatch<?> entitypatch;
    private final List<TrailEdge> invisibleTrailEdges;
    private final List<TrailEdge> visibleTrailEdges;
    private boolean animationEnd;
    private float startEdgeCorrection = 0.0f;

    protected BloomTrailParticle(ClientLevel level, LivingEntityPatch<?> entitypatch, Joint joint, StaticAnimation animation, TrailInfo trailInfo, SpriteSet spriteSet) {
        super(level, 0.0, 0.0, 0.0);
        this.joint = joint;
        this.entitypatch = entitypatch;
        this.animation = animation;
        this.invisibleTrailEdges = Lists.newLinkedList();
        this.visibleTrailEdges = Lists.newLinkedList();
        this.f_107219_ = false;
        this.trailInfo = trailInfo;
        Vec3 entityPos = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
        float size = (float)Math.max(this.trailInfo.start.m_82553_(), this.trailInfo.end.m_82553_()) * 2.0f;
        this.m_107250_(size, size);
        this.m_6257_(entityPos.f_82479_, entityPos.f_82480_ + (double)((LivingEntity)entitypatch.getOriginal()).m_20192_(), entityPos.f_82481_);
        this.m_108339_(spriteSet);
        Pose prevPose = this.entitypatch.getAnimator().getPose(0.0f);
        Pose middlePose = this.entitypatch.getAnimator().getPose(0.5f);
        Pose currentPose = this.entitypatch.getAnimator().getPose(1.0f);
        Vec3 posOld = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(0.0f);
        Vec3 posMid = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(0.5f);
        Vec3 posCur = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(1.0f);
        OpenMatrix4f prvmodelTf = OpenMatrix4f.createTranslation((float)((float)posOld.f_82479_), (float)((float)posOld.f_82480_), (float)((float)posOld.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(this.entitypatch.getModelMatrix(0.0f)));
        OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)((float)posMid.f_82479_), (float)((float)posMid.f_82480_), (float)((float)posMid.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(this.entitypatch.getModelMatrix(0.5f)));
        OpenMatrix4f curModelTf = OpenMatrix4f.createTranslation((float)((float)posCur.f_82479_), (float)((float)posCur.f_82480_), (float)((float)posCur.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(this.entitypatch.getModelMatrix(1.0f)));
        OpenMatrix4f prevJointTf = this.entitypatch.getArmature().getBindedTransformFor(prevPose, this.joint).mulFront(prvmodelTf);
        OpenMatrix4f middleJointTf = this.entitypatch.getArmature().getBindedTransformFor(middlePose, this.joint).mulFront(middleModelTf);
        OpenMatrix4f currentJointTf = this.entitypatch.getArmature().getBindedTransformFor(currentPose, this.joint).mulFront(curModelTf);
        Vec3 prevStartPos = OpenMatrix4f.transform((OpenMatrix4f)prevJointTf, (Vec3)trailInfo.start);
        Vec3 prevEndPos = OpenMatrix4f.transform((OpenMatrix4f)prevJointTf, (Vec3)trailInfo.end);
        Vec3 middleStartPos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)trailInfo.start);
        Vec3 middleEndPos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)trailInfo.end);
        Vec3 currentStartPos = OpenMatrix4f.transform((OpenMatrix4f)currentJointTf, (Vec3)trailInfo.start);
        Vec3 currentEndPos = OpenMatrix4f.transform((OpenMatrix4f)currentJointTf, (Vec3)trailInfo.end);
        this.invisibleTrailEdges.add(new TrailEdge(prevStartPos, prevEndPos, this.trailInfo.trailLifetime));
        this.invisibleTrailEdges.add(new TrailEdge(middleStartPos, middleEndPos, this.trailInfo.trailLifetime));
        this.invisibleTrailEdges.add(new TrailEdge(currentStartPos, currentEndPos, this.trailInfo.trailLifetime));
        this.f_107227_ = this.trailInfo.rCol;
        this.f_107228_ = this.trailInfo.gCol;
        this.f_107229_ = this.trailInfo.bCol;
    }

    public void m_5989_() {
        boolean visibleTrail;
        List finalEndPositions;
        List finalStartPositions;
        boolean needCorrection;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (((LivingEntity)this.entitypatch.getOriginal()).m_6084_()) {
            Vec3 pos = ((LivingEntity)this.entitypatch.getOriginal()).m_20182_();
            this.m_107264_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
        AnimationPlayer animPlayer = this.entitypatch.getAnimator().getPlayerFor((DynamicAnimation)this.animation);
        this.visibleTrailEdges.removeIf(v -> !v.isAlive());
        if (this.animationEnd) {
            if (this.f_107225_-- == 0) {
                this.m_107274_();
            }
        } else if (!((LivingEntity)this.entitypatch.getOriginal()).m_6084_() || this.animation != animPlayer.getAnimation().getRealAnimation() || animPlayer.getElapsedTime() > this.trailInfo.endTime) {
            this.animationEnd = true;
            this.f_107225_ = this.trailInfo.trailLifetime;
        }
        boolean isTrailInvisible = animPlayer.getAnimation() instanceof LinkAnimation || animPlayer.getElapsedTime() <= this.trailInfo.startTime;
        boolean isFirstTrail = this.visibleTrailEdges.size() == 0;
        boolean bl = needCorrection = !isTrailInvisible && isFirstTrail;
        if (needCorrection) {
            float startCorrection = Math.max((this.trailInfo.startTime - animPlayer.getPrevElapsedTime()) / (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()), 0.0f);
            this.startEdgeCorrection = (float)(this.trailInfo.interpolateCount * 2) * startCorrection;
        }
        TrailInfo trailInfo = this.trailInfo;
        Pose prevPose = this.entitypatch.getAnimator().getPose(0.0f);
        Pose middlePose = this.entitypatch.getAnimator().getPose(0.5f);
        Pose currentPose = this.entitypatch.getAnimator().getPose(1.0f);
        Vec3 posOld = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(0.0f);
        Vec3 posMid = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(0.5f);
        Vec3 posCur = ((LivingEntity)this.entitypatch.getOriginal()).m_20318_(1.0f);
        OpenMatrix4f prvmodelTf = OpenMatrix4f.createTranslation((float)((float)posOld.f_82479_), (float)((float)posOld.f_82480_), (float)((float)posOld.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(this.entitypatch.getModelMatrix(0.0f)));
        OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)((float)posMid.f_82479_), (float)((float)posMid.f_82480_), (float)((float)posMid.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(this.entitypatch.getModelMatrix(0.5f)));
        OpenMatrix4f curModelTf = OpenMatrix4f.createTranslation((float)((float)posCur.f_82479_), (float)((float)posCur.f_82480_), (float)((float)posCur.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(this.entitypatch.getModelMatrix(1.0f)));
        OpenMatrix4f prevJointTf = this.entitypatch.getArmature().getBindedTransformFor(prevPose, this.joint).mulFront(prvmodelTf);
        OpenMatrix4f middleJointTf = this.entitypatch.getArmature().getBindedTransformFor(middlePose, this.joint).mulFront(middleModelTf);
        OpenMatrix4f currentJointTf = this.entitypatch.getArmature().getBindedTransformFor(currentPose, this.joint).mulFront(curModelTf);
        Vec3 prevStartPos = OpenMatrix4f.transform((OpenMatrix4f)prevJointTf, (Vec3)trailInfo.start);
        Vec3 prevEndPos = OpenMatrix4f.transform((OpenMatrix4f)prevJointTf, (Vec3)trailInfo.end);
        Vec3 middleStartPos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)trailInfo.start);
        Vec3 middleEndPos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)trailInfo.end);
        Vec3 currentStartPos = OpenMatrix4f.transform((OpenMatrix4f)currentJointTf, (Vec3)trailInfo.start);
        Vec3 currentEndPos = OpenMatrix4f.transform((OpenMatrix4f)currentJointTf, (Vec3)trailInfo.end);
        if (isTrailInvisible) {
            finalStartPositions = Lists.newArrayList();
            finalEndPositions = Lists.newArrayList();
            finalStartPositions.add(prevStartPos);
            finalStartPositions.add(middleStartPos);
            finalEndPositions.add(prevEndPos);
            finalEndPositions.add(middleEndPos);
            this.invisibleTrailEdges.clear();
            visibleTrail = false;
        } else {
            TrailEdge edge2;
            TrailEdge edge1;
            ArrayList startPosList = Lists.newArrayList();
            ArrayList endPosList = Lists.newArrayList();
            if (isFirstTrail) {
                int lastIdx = this.invisibleTrailEdges.size() - 1;
                edge1 = this.invisibleTrailEdges.get(lastIdx);
                edge2 = new TrailEdge(prevStartPos, prevEndPos, -1);
            } else {
                edge1 = this.visibleTrailEdges.get(this.visibleTrailEdges.size() - (this.trailInfo.interpolateCount / 2 + 1));
                edge2 = this.visibleTrailEdges.get(this.visibleTrailEdges.size() - 1);
                ++edge2.lifetime;
            }
            startPosList.add(edge1.start);
            endPosList.add(edge1.end);
            startPosList.add(edge2.start);
            endPosList.add(edge2.end);
            startPosList.add(middleStartPos);
            endPosList.add(middleEndPos);
            startPosList.add(currentStartPos);
            endPosList.add(currentEndPos);
            finalStartPositions = CubicBezierCurve.getBezierInterpolatedPoints((List)startPosList, (int)1, (int)3, (int)this.trailInfo.interpolateCount);
            finalEndPositions = CubicBezierCurve.getBezierInterpolatedPoints((List)endPosList, (int)1, (int)3, (int)this.trailInfo.interpolateCount);
            if (!isFirstTrail) {
                finalStartPositions.remove(0);
                finalEndPositions.remove(0);
            }
            visibleTrail = true;
        }
        this.makeTrailEdges(finalStartPositions, finalEndPositions, visibleTrail ? this.visibleTrailEdges : this.invisibleTrailEdges);
    }

    public void m_5744_(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float partialTick) {
        if (this.visibleTrailEdges.isEmpty()) {
            return;
        }
        if (!PostEffectPipelines.isActive() || !((LivingEntity)this.entitypatch.getOriginal()).m_6084_()) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        int light = 0xF000F0;
        this.setupPoseStack(poseStack, camera, partialTick);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        int edges = this.visibleTrailEdges.size() - 1;
        boolean startFade = this.visibleTrailEdges.get((int)0).lifetime == 1;
        boolean endFade = this.visibleTrailEdges.get((int)edges).lifetime == this.trailInfo.trailLifetime;
        float startEdge = (startFade ? (float)(this.trailInfo.interpolateCount * 2) * partialTick : 0.0f) + this.startEdgeCorrection;
        float endEdge = endFade ? Math.min((float)edges - (float)(this.trailInfo.interpolateCount * 2) * (1.0f - partialTick), (float)(edges - 1)) : (float)(edges - 1);
        float interval = 1.0f / (endEdge - startEdge);
        float fading = 1.0f;
        if (this.animationEnd) {
            fading = Mth.m_14036_((float)(((float)this.f_107225_ + (1.0f - partialTick)) / (float)this.trailInfo.trailLifetime), (float)0.0f, (float)1.0f);
        }
        float partialStartEdge = interval * (startEdge % 1.0f);
        float from = -partialStartEdge;
        float to = -partialStartEdge + interval;
        for (int i = (int)startEdge; i < (int)endEdge + 1; ++i) {
            TrailEdge e1 = this.visibleTrailEdges.get(i);
            TrailEdge e2 = this.visibleTrailEdges.get(i + 1);
            Vector4f pos1 = new Vector4f((float)e1.start.f_82479_, (float)e1.start.f_82480_, (float)e1.start.f_82481_, 1.0f);
            Vector4f pos2 = new Vector4f((float)e1.end.f_82479_, (float)e1.end.f_82480_, (float)e1.end.f_82481_, 1.0f);
            Vector4f pos3 = new Vector4f((float)e2.end.f_82479_, (float)e2.end.f_82480_, (float)e2.end.f_82481_, 1.0f);
            Vector4f pos4 = new Vector4f((float)e2.start.f_82479_, (float)e2.start.f_82480_, (float)e2.start.f_82481_, 1.0f);
            pos1.mul((Matrix4fc)matrix4f);
            pos2.mul((Matrix4fc)matrix4f);
            pos3.mul((Matrix4fc)matrix4f);
            pos4.mul((Matrix4fc)matrix4f);
            float alphaFrom = Mth.m_14036_((float)(Mth.m_14036_((float)from, (float)0.0f, (float)1.0f) * this.f_107230_ * fading), (float)0.0f, (float)1.0f);
            float alphaTo = Mth.m_14036_((float)(Mth.m_14036_((float)to, (float)0.0f, (float)1.0f) * this.f_107230_ * fading), (float)0.0f, (float)1.0f);
            alphaFrom = Mth.m_14116_((float)alphaFrom);
            alphaTo = Mth.m_14116_((float)alphaTo);
            vertexConsumer.m_5483_((double)pos1.x(), (double)pos1.y(), (double)pos1.z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alphaFrom).m_7421_(from, 1.0f).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)pos2.x(), (double)pos2.y(), (double)pos2.z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alphaFrom).m_7421_(from, 0.0f).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)pos3.x(), (double)pos3.y(), (double)pos3.z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alphaTo).m_7421_(to, 0.0f).m_85969_(light).m_5752_();
            vertexConsumer.m_5483_((double)pos4.x(), (double)pos4.y(), (double)pos4.z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alphaTo).m_7421_(to, 1.0f).m_85969_(light).m_5752_();
            from += interval;
            to += interval;
        }
    }

    public boolean shouldCull() {
        return false;
    }

    public ParticleRenderType m_7556_() {
        return EpicACGRenderType.getBloomRenderTypeByTexture(this.trailInfo.texturePath);
    }

    protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(-vec3.m_7096_());
        float y = (float)(-vec3.m_7098_());
        float z = (float)(-vec3.m_7094_());
        poseStack.m_252880_(x, y, z);
    }

    private void makeTrailEdges(List<Vec3> startPositions, List<Vec3> endPositions, List<TrailEdge> dest) {
        for (int i = 0; i < startPositions.size(); ++i) {
            dest.add(new TrailEdge(startPositions.get(i), endPositions.get(i), this.trailInfo.trailLifetime));
        }
    }

    private static class TrailEdge {
        final Vec3 start;
        final Vec3 end;
        int lifetime;

        public TrailEdge(Vec3 start, Vec3 end, int lifetime) {
            this.start = start;
            this.end = end;
            this.lifetime = lifetime;
        }

        boolean isAlive() {
            return --this.lifetime > 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            int eid = (int)Double.doubleToRawLongBits(x);
            int animid = (int)Double.doubleToRawLongBits(z);
            int jointId = (int)Double.doubleToRawLongBits(xSpeed);
            int idx = (int)Double.doubleToRawLongBits(ySpeed);
            Entity entity = level.m_6815_(eid);
            if (entity != null) {
                ItemStack stack;
                ItemSkin itemSkin;
                LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
                StaticAnimation animation = AnimationManager.getInstance().byId(animid);
                Optional trailInfo = animation.getProperty((AnimationProperty)ClientAnimationProperties.TRAIL_EFFECT);
                TrailInfo result = (TrailInfo)((List)trailInfo.get()).get(idx);
                if (result.hand != null && (itemSkin = ItemSkins.getItemSkin((Item)(stack = ((LivingEntity)entitypatch.getOriginal()).m_21120_(result.hand)).m_41720_())) != null) {
                    result = itemSkin.trailInfo().overwrite(result);
                }
                if (entitypatch != null) {
                    return new BloomTrailParticle(level, entitypatch, entitypatch.getArmature().searchJointById(jointId), animation, result, this.spriteSet);
                }
            }
            return null;
        }
    }
}

